(
	-- Blend Material

	struct AMGData 
	(
		fn GetUUID mtl context =
		(
			"c0a9d104-c110-49f9-8cf7-82171c872bdd"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			append res #("Mtl1", mtl.map1, "material")
			append res #("Mtl2", mtl.map2, "material")

			if mtl.mask != undefined and mtl.maskEnabled do 
				append res #("Blend", mtl.mask, "resultFloat")

			res
		),

		fn GetParams mtl context =
		(
			local res = #()	

			-- In "percent", so divide by 100....
			append res #("Blend",      mtl.mixAmount / 100.0)

			if (mtl.maskEnabled) do (
				append res #("UseCurve",   mtl.useCurve)
				append res #("Low",        mtl.lower)
				append res #("High",       mtl.upper)
			)

			res
		)
	)
	
	AMGData()
)